/* ==================== Massduino UnoPro_Code Template =============================
  Version: 1.0
  Release: 22 May.2018
  www.inhaos.com

  Function：
  use PWM DAC channel output analog signal.
  PWM_DAC use pin 33,34,36,37 , the max solution is 16bit.
  The analog reference source is 4.06V

  The stable time is about 30mS , which means the DAC speed is 333 sps
  if you want higher resolution ,   you need to modify the PWM RC low pass filter .
  ==================================================================================*/
#include <WDT.h>

#define pin_SCK_LED       13

#define pin_BTN1              29
#define pin_BTN2              30
#define pin_BTN3              32
#define pin_LED1              31
#define pin_LED2              38
#define pin_LED3              39

#define pin_PWM_DAC_CH0       33
#define pin_PWM_DAC_CH1       34
#define pin_PWM_DAC_CH2       36
#define pin_PWM_DAC_CH3       37

#define pin_HV_AIN_CH0        A6
#define pin_HV_AIN_CH1        A7
#define pin_HV_AIN_CH2        A8
#define pin_HV_AIN_CH3        A9
#define pin_HV_AIN_CH4        A11

#define pin_AREF_SOURCE       35
#define fun_SetARF_4096       { digitalWrite ( 35 , HIGH ) ; }
#define fun_SetARF_2048       { digitalWrite ( 35 , LOW ) ; }

#define UART_BAUDRATE         115200

void setup() {
  sysClock ( EXT_OSC );               // switch system clock source to 16MHz ext osc
 
  // initial PWM pin , the PWM resolution 12bit , DAC resolution 1mV .
  pwmMode ( pin_PWM_DAC_CH0, PWM_MODE_NORMAL, PWM_FREQ_FAST, 0 );
  pwmMode ( pin_PWM_DAC_CH1, PWM_MODE_NORMAL, PWM_FREQ_FAST, 0 );
  pwmMode ( pin_PWM_DAC_CH2, PWM_MODE_NORMAL, PWM_FREQ_FAST, 0 );
  pwmMode ( pin_PWM_DAC_CH3, PWM_MODE_NORMAL, PWM_FREQ_FAST, 0 );

  pwmResolution (pin_PWM_DAC_CH0, 16 ); // the setting also effect to PWM_DAC_CH1 since CH0 and CH1 use same of TIM3
  pwmResolution (pin_PWM_DAC_CH2, 12 ); // the setting also effect to PWM_DAC_CH3 since CH2 and CH3 use same of TIM1

  // initial analog refernce source
  analogReference ( EXTERNAL ) ;      //switch analog reference source to AVREF
  fun_SetARF_2048 ;

  wdt_enable(WTO_256MS);             // enable the watchdog , period 256mS

  Serial.begin ( UART_BAUDRATE ) ;
}

void loop() {
  wdt_reset();                        // remember to reset the watchdog in main loop if you enabel the watchdog.
  // wdt_disable();                   // disable the watchdog if you do not want it work anymore
}

